/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.player.GuiDialogInteract;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.entity.EntityNPCInterface;
import org.lwjgl.Sys;

public class NoppesUtil {
    private static final HashMap<String, Integer> data = new HashMap();
    private static EntityNPCInterface lastNpc;

    public static void addScrollData(ByteBuf buffer) {
        Map<Object, Object> map = Server.readMap(buffer);
        for (Object name : map.keySet()) {
            Object id = map.get(name);
            if (!(id instanceof Integer)) continue;
            data.put(name.toString(), (Integer)id);
        }
    }

    public static void clickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public static EntityNPCInterface getLastNpc() {
        return lastNpc;
    }

    public static void openDialog(Dialog dialog, EntityNPCInterface npc, EntityPlayer player) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!(gui instanceof GuiDialogInteract)) {
            CustomNpcs.proxy.openGui(player, new GuiDialogInteract(npc, dialog));
        } else {
            gui.func_73866_w_();
            ((GuiDialogInteract)gui).appendDialog(dialog);
        }
    }

    public static void openFolder(File dir) {
        String s = dir.getAbsolutePath();
        if (Util.func_110647_a() == Util.EnumOS.OSX) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", s});
                return;
            }
            catch (IOException ex) {}
        } else if (Util.func_110647_a() == Util.EnumOS.WINDOWS) {
            String s2 = String.format("cmd.exe /C start \"Open file\" \"%s\"", s);
            try {
                Runtime.getRuntime().exec(s2);
                return;
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
        }
        boolean flag = false;
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, dir.toURI());
        }
        catch (Throwable throwable) {
            flag = true;
        }
        if (flag) {
            Sys.openURL((String)("file://" + s));
        }
    }

    public static void openGUI(EntityPlayer player, Object guiscreen) {
        CustomNpcs.proxy.openGui(player, guiscreen);
    }

    public static void requestOpenGUI(EnumGuiType gui) {
        NoppesUtil.requestOpenGUI(gui, 0, 0, 0);
    }

    public static void requestOpenGUI(EnumGuiType gui, int x, int y, int z) {
        Client.sendData(EnumPacketServer.Gui, gui.ordinal(), x, y, z);
    }

    public static void setLastNpc(EntityNPCInterface npc) {
        lastNpc = npc;
    }

    public static void setScrollData(ByteBuf buffer) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null) {
            return;
        }
        if (gui instanceof GuiNPCInterface && ((GuiNPCInterface)gui).hasSubGui()) {
            gui = ((GuiNPCInterface)gui).getSubGui();
        }
        if (gui instanceof GuiContainerNPCInterface && ((GuiContainerNPCInterface)gui).hasSubGui()) {
            gui = ((GuiContainerNPCInterface)gui).getSubGui();
        }
        if (!(gui instanceof IScrollData)) {
            return;
        }
        Map<Object, Object> map = Server.readMap(buffer);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            try {
                data.put((String)entry.getKey(), (int)((Integer)entry.getValue()));
            }
            catch (Exception e) {
                LogWriter.error("Error set scroll data: " + entry.getKey() + ":" + entry.getValue(), e);
            }
        }
        ((IScrollData)gui).setData(new Vector<String>(data.keySet()), data);
        data.clear();
    }

    public static void setScrollList(ByteBuf buffer) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiNPCInterface && ((GuiNPCInterface)gui).hasSubGui()) {
            gui = ((GuiNPCInterface)gui).getSubGui();
        }
        if (!(gui instanceof IScrollData)) {
            return;
        }
        Vector<String> data = new Vector<String>();
        try {
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                data.add(Server.readString(buffer));
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        ((IScrollData)gui).setData(data, null);
    }

    public static void spawnParticle(ByteBuf buffer) throws IOException {
        double posX = buffer.readDouble();
        double posY = buffer.readDouble();
        double posZ = buffer.readDouble();
        float height = buffer.readFloat();
        float width = buffer.readFloat();
        String particle = Server.readString(buffer);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Random rand = world.field_73012_v;
        assert (particle != null);
        if (particle.equals("heal")) {
            for (int k = 0; k < 6; ++k) {
                world.func_175688_a(EnumParticleTypes.SPELL_INSTANT, posX + (rand.nextDouble() - 0.5) * (double)width, posY + rand.nextDouble() * (double)height, posZ + (rand.nextDouble() - 0.5) * (double)width, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.SPELL, posX + (rand.nextDouble() - 0.5) * (double)width, posY + rand.nextDouble() * (double)height, posZ + (rand.nextDouble() - 0.5) * (double)width, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

